/*
 *  GridCell.cpp
 *  Pirates!
 *
 *  Created by Alan Dorin on 12/03/10.
 *  Copyright 2007 __MyCompanyName__. All rights reserved.
 *
 */
 
#include "GridCell.h"

#include "ShipBase.h"
#include "Gold.h"

GridCell::GridCell(void)
{
	position.set(0);
	dimensions.set(1);
	ship=NULL;
	gold=NULL;
	cannonBallPassedThrough = false;
	rock=false;
	wreck=false;
}

GridCell::GridCell(const GridCell& src)
{
	position				= src.position;
	dimensions				= src.dimensions;
	
	// copy the pointer to an existing ship object into the new GridCell
	ship					= src.ship;
	
	// copy the pointer to an existing gold object into the new GridCell
	gold					= src.gold;
	
	cannonBallPassedThrough = src.cannonBallPassedThrough;
	rock					= src.rock;
	wreck					= src.wreck;
}

GridCell::~GridCell(void)
{
	// don't delete the ship/element! (these are kept/new-d/deleted in GridCell_ARRAY)
	// don't delete the gold! (these are kept/new-d/deleted in GridCell_ARRAY)
}


void GridCell::setShipPtr(Ship* shipPtr)
{
	if (ship!=NULL)
	{
		std::cerr << "\nERROR: (GridCell::setShip) attempt to set Ship in occupied GridCell.";
		exit(1);
	}
	
	else
	{
		ship = shipPtr;
	}
}

void GridCell::clearShip(void)
{ ship = NULL; }			// don't delete the ship object! (these are kept/new-d/deleted in Patch)

int GridCell::getShipId(void)
{	return ((ship!=NULL) ? ship->getId() : -1);	}

void GridCell::setGoldPtr(Gold* goldPtr)
{
	if (gold!=NULL)
	{
		std::cerr << "\nERROR: (GridCell::setGold) attempt to set Gold in occupied GridCell.";
		exit(1);
	}
	
	else
	{
		gold = goldPtr;
	}
}

void GridCell::clearGold(void)
{ gold = NULL; }			// don't delete the gold object! (these are kept/new-d/deleted in Sea)

int GridCell::getGoldIndex(void)
{
	return ((gold!=NULL) ? gold->getIndex() : -1);
}

bool GridCell::isOccupiedByShip(void)
{
	if (ship==NULL)
	{	return false;	}
	
	else
	{ return true; }
}

bool GridCell::isOccupiedByGold(void)
{	return ((gold!=NULL) ? true : false);	}

void GridCell::setCannonBallPassedThrough(bool ballFlag)
{	cannonBallPassedThrough = ballFlag;	}

bool GridCell::getCannonBallPassedThrough(void)
{	return cannonBallPassedThrough;	}

void GridCell::clearCannonBallPassedThrough(void)
{	cannonBallPassedThrough = false; }

void GridCell::setRock(void)
{ rock=true; }

void GridCell::clearRock(void)
{ rock=false; }

void GridCell::setWreck(void)
{ wreck=true; }

void GridCell::clearWreck(void)
{ wreck=false; }

bool GridCell::isOccupiedByWreck(void)
{ return wreck; }

bool GridCell::isOccupiedByRock(void)
{ return rock; }

void GridCell::setPosition(const SimpleVector& newPos)
{ position=newPos; }

SimpleVector GridCell::getPosition(void)
{ return position; }

void GridCell::setDimensions(const SimpleVector& newDim)
{ dimensions=newDim; }

SimpleVector GridCell::getDimensions(void)
{ return dimensions; }

void GridCell::displayShip(void)
{
	if (ship != NULL)
	{	ship->display(position, dimensions);	}
}

void GridCell::displayGold(void)
{
	if (gold != NULL)
	{	gold->display(position, dimensions);	}
}

void GridCell::displayCannonPath(void)
{
	extern void drawMark(const SimpleVector& position);
	SimpleVector red(0.5,0,0), green(0,0.9,0);
	
	if (cannonBallPassedThrough)
	{
		// place a mark in the center of this cell
		green.vector_gl_colour();
		drawMark(position);
	}
}

void GridCell::displayRock(void)
{
	extern void drawFillSquare(const SimpleVector& position, const SimpleVector& dimensions);
	extern void drawWireSquare(const SimpleVector& position, const SimpleVector& dimensions);
	SimpleVector grey(0.6,0.7,0.7);
	
	if (rock)
	{
		grey.vector_gl_colour();
		drawFillSquare(position, dimensions);
	}
}

void GridCell::displayWreck(void)
{
	extern void drawFillSquare(const SimpleVector& position, const SimpleVector& dimensions);
	extern void drawWireSquare(const SimpleVector& position, const SimpleVector& dimensions);
	SimpleVector blue(0.0,0.0,0.7);
	
	if (wreck)
	{
		blue.vector_gl_colour();
		drawWireSquare(position, dimensions);
	}
}

void GridCell::displayCellIndex(long number)
{
	extern void writeTextString(const SimpleVector& rasterPosition, char* nameString);
	
	SimpleVector white(1.0,1.0,1.0);
	
	white.vector_gl_colour();
	
	char theName[10];
	sprintf(theName, "%ld", number);
	writeTextString(position, theName);
}

GridCell& GridCell::operator= (const GridCell& rhs)
{
	position = rhs.position;
	dimensions = rhs.dimensions;
	ship = rhs.ship;
	gold = rhs.gold;
	cannonBallPassedThrough = rhs.cannonBallPassedThrough;
	rock = rhs.rock;
	wreck = rhs.wreck;
	
	return *this;
}
